;**********************************************************************
; Programme de surveillance de contact pour alarme                    *
;                                                                     *
;    NOM:      AL16F84.ASM                                            *
;    Date:     10/01/2008                                             *
;    Version:  2.0                                                    *
;    Auteur:   FF                                                     *
;                                                                     *
;                                                                     *
;                 c .                                                 *
;                                                                     *
;    Il est possible que les entres soient toutes  contacts         *
;    normalement ferms pour une consommation suprieure. Modifier    *
;    la variable TYPE_NO_NF.                                          *
;                                                                     *
;                                                                     *
; Les temporisations sont donnes pour un rsonateur  32,768Khz.     *
; Une instruction = 125  secondes.                                   *
; Vive le logiciel libre de droit, de taxe, de drm,...                *
;                                                                     *
;---------------------------------------------------------------------*
;    Fichier requis pour la compilation : P16F84.inc                  *
;---------------------------------------------------------------------*
;
; Les signalisations externe au boitier sont : Leds Verte, Orange+Buzzer en //, Rouge
;
; Indications en face avant,  la mise en route le montage :
;   Led verte           = Allum le temps de sortir (variable TEMPO_INIT).
;   Led orange + buzzer = Clignotent si la porte principale est ouverte (variable TEMPO_PREALA).
;                       = Allum en continu si en plus la led rouge est allume.
;   Led rouge           = Allum si une un contact est actif. (dfaut des boucles).
;
;
; Indications en face avant,  l'ouverture de la porte principale.
;   Led verte           = Eteinte.
;   Led orange + buzzer = Clignotent pour avertissement avant alarme.
;                       = Allum en continu si en plus la led rouge est allume.
;   Led rouge           = Il y a dj eu une alarme dtecte.
;
; Indications en face avant,  l'ouverture d'un autre contact.
;   Leds eteintes pour rester discret, pour viter que l'on casse inutilement ce coffret dport.
;
;------------------------------------------------------------------------------*
;
; Au bout d'un certain nombre d'alarme sonore (NB_ALARME = variable interne
;   au programme) le montage fonctionne encore, mais n'active plus les
;   relais fixe et clignotant. Le montage n'est donc plus sonore pour viter
;   de faire du bruit indfiniment (le reste du montage et le relais
;   temporis fonctionne encore).
;
; Le relais temporis (relais tempo.) sert  activer un magntophone ou
;   autre appareil enregistreur. Il est activ sur alarme pendant une priode
;   de TEMPO_REL_T minutes (typiquement 5 mn).
;   (TEMPO_REL_T = variable interne au programme).
;
;
;------------------------------------------------------------------------------*
;
; Fonctionnement de cette alarme
;
; Mise sous tension de l'alarme
; On est en mode normal, le cavalier de test  + 5 Volts
;
; On passe en mode initialisation.
;   Dmarrage de la temporisation d'initialisation de l'alarme.
;    - La led verte est allume.
;    - La led orange + buzzer clignotent, si la porte principale est ouverte.
;      Allum en continu si en plus la led rouge est allume.
;    - La led rouge est allume, si un des contacts, botier, fentres ou
;      portes (sauf porte principale) est ouverte.(c'est peut tre un dfaut).
;   Au bout de TEMPO_INIT secondes, le montage passe en veille.
;
; On passe en mode veille.
;   Les 3 leds s'teignent.
;    - S'il on ouvre la porte pripale, on passe en mode pralarme.
;    - S'il on change l'tat d'un contact autre que celui de la porte principale,
;      (ouverture ou fermeture), on passe immdiatement en mode alarme.
;   Sinon on boucle en mode veille.
; 
;
; Ici on est  en mode pralarme.
;    - La led orange + buzzer clignotent.
;      Allum en continu si la led rouge est allume.
;    - s'il y a dj eu une alarme, La led rouge s'allume. Ceci pour signaler que
;      l'alarme  dj fonctionne, (intrusion ou faux contact).
;    - S'il on change l'tat d'un contact autre que celui de la porte principale,
;      (ouverture ou fermeture), on passe immdiatement en mode alarme.
;    - Au bout de TEMPO_PRE_ALA secondes, le montage passe automatiquement
;      en mode alarme, (TEMPO_PRE_ALA = variable interne au programme).
;   Sinon on boucle en mode pralarme.
;
;
; Ici on est en mode alarme.
;    - On active les 3 relais.
;    - Les 3 leds s'teignent, (pour rester discret sur le panneau d'alarme).
;    - S'il on change l'tat un  contact (ouvre ou ferme un contact), 
;      la tempo TEMPO_ALA est remise  zro.
;    - Au bout de TEMPO_ALA secondes, le montage repasse en mode veille,
;      (TEMPO_ALA = variable interne au programme)
;   Sinon on boucle en mode alarme.
; Le port RB4 est utilis par l'interrupteur de test, car cette entre consomme plus que les autres.
;
;------------------------------------------------------------------------------*
;
; Utilisation des broches du circuit :
;                                        ____ _____
; contact porte principale        RA2   [1   U   18]    RA1      relais tempo
; contact porte 1                 RA3   [2       17]    RA0      relais clignotant
; contact entre de test      RA4/TOCKI [3       16] OSC1/CLKIN  rsonateur
; reset                          MCLR   [4  PIC  15] OSC2/CLKOUT 32 kHz
; masse                          Masse  [5       16]    VDD      +5 Volts
; contact porte 2              RB0/INT  [6 16F84 13]    RB7      relais fixe
; contact ouverture fentre 1     RB1   [7       12]    RB6      led rouge
; contact ouverture fentre 2     RB2   [8       11]    RB5      led orange
; contact ouverture boitier       RB3   [9_______10]    RB4      led verte
;
;------------------------------------------------------------------------------*
;
; Led verte :
;   - Pendant la mise en route de l'alarme, cette led s'allume.
;     La mise en route de l'alarme dure TEMPO_INIT secondes.
;   - En mode veille, la led verte est teinte.
;   - En mode pralarme, la led verte est teinte.
;   - En mode alarme, la led vert est teinte.
;
; Led orange + buzzer en parallle :
;   - Pendant la mise en route de l'alarme, si un la porte principale est
;     ouverte, la led orange clignote, sinon elle reste teinte.
;     Allum en continu si la led rouge est allume.
;   - En mode veille, la led orange est teinte.
;   - En mode pralarme, la led orange clignote.
;     Allum en continu si la led rouge est allume.
;   - En mode alarme, la led orange est teinte.
;
; Led rouge :
;   - Pendant la mise en route de l'alarme, si un des contacts, botier,
;     fentres ou portes (sauf porte principale) est ouvert, cette led s'allume.
;   - En mode veille cette led clignote faiblement (un bref flash toutes
;     les secondes).
;   - En mode pralarme, la led rouge s'allume s'il a dj eu une alarme depuis
;     la mise sous tension. (Intrusion ou faux contacts).
;   - En mode alarme, la led rouge est teinte.
;
;
; Entre de test :
;   Si cette entre est au relie  la masse, 0 volts (cavalier), on est en mode test.
;   On passe donc dans une routine spciale, si le cavalier RA[4] est positionn  +5V.
;   Le programme reste en mode test indfiniment, jusqu'au prochain reset.
;   Dans cette squence, on met un certain nombre de bips buzzer  chaque
;   ouverture ou fermeture de contact. Pas d'alarme sonore.
;   De plus, la led verte s'allume si le contact est maintenant ferm,
;            la led rouge s'allume si le contact est maintenant ouvert.
;
;   Si l'on ferme ou ouvre la porte principale : 1 bip  buzzer
;             //           la porte 1          : 2 bips buzzer
;             //           la porte 2          : 3 bips buzzer
;             //           la fentre 1        : 4 bips buzzer
;             //           la fentre 2        : 5 bips buzzer
;             //           le botier          : 6 bips buzzer
;
; Contact porte principale :
;   - En mode alarme, l'ouverture de la porte principale provoque
;     l'tat pralarme.
;     Au bout de TEMPO_PRE_ALA secondes, l'alarme se met en route pendant
;     TEMPO_ALA secondes.
;
; Contact ouverture boitier :
;   - L'ouverture ou la fermeture du boitier met en route l'alarme immdiatement.
;
; Contact ouverture fentre 1 ou contact ouverture fentre 2 :
;   - L'ouverture ou la fermeture d'une fentre met en route l'alarme immdiatement.
;
; Contact porte 1 ou contact porte 2 :
;   - L'ouverture ou la fermeture d'une porte met en route l'alarme immdiatement.
;
; Relais fixe et relais clignotant :
;   - Ces relais servent  activer une sirne et des avertisseurs lumineux.
;   - Pendant la priode d'alarme, les relais fixe et clignotant sont activs.
;   - Le relais clignotant  une priode de 2 secondes.
;
; Relais tempo :
;   - Ce relais peut activer un magntophone ou autre appareil enregistreur.
;   - Pendant la priode d'alarme, le relais temporis est activ sur
;     une priode de TEMPO_REL_T minutes (typiquement 5 mn).
;
; Rsonateur 32 kHz  :
;   - Rsonateur faible consommation pour obtenir les temporisations souhaites.
;
;**********************************************************************

	LIST	p=16F84	; Dfinition de processeur
	#include	<p16F84.inc>	; Dfinitions des variables

; Mis en remarque  cause d'une anomalie lors de la simulation. Retirer le ; pour programmer le pic.
 	__CONFIG	_CP_OFF & _WDT_OFF & _PWRTE_OFF & _LP_OSC

	ERRORLEVEL  -302

; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur.
;
; Les dfinitions sont dans le fichier include.
; Voici les valeurs et leurs dfinitions :
;	_CP_ON		Code protection ON : impossible de relire
;	_CP_OFF		Code protection OFF
;	_PWRTE_ON	Timer reset sur power on en service
;	_PWRTE_OFF	Timer reset hors-service
;	_WDT_ON		Watch-dog en service
;	_WDT_OFF	Watch-dog hors service
;	_LP_OSC		Oscillateur quartz basse vitesse
;	_XT_OSC		Oscillateur quartz moyenne vitesse
;	_HS_OSC		Oscillateur quartz grande vitesse
;	_RC_OSC		Oscillateur  rseau RC

;*********************************************************************
;                        ASSIGNATIONS                                *
;*********************************************************************

OPTIONVAL	EQU	H'008F'	; Valeur registre option	
					; Rsistance pull-up OFF
					; Prscaler wdt  128

INTERMASK	EQU	H'0000'	; Pas d'interruption


;*********************************************************************
;                        DEFINITIONS                                 *
;*********************************************************************
#define	NB_MAX_ALA      .05	; Nombre maximum d'alarmes sonores (5 fois par dfaut)
#define	TEMPO_INIT      .60	; Dure de mise en route en secondes (60 sec. par dfaut)
#define	TEMPO_PREALA    .60	; Dure de pralarme avant alarme en secondes (60 sec. par dfaut)
#define	TEMPO_ALA       .60	; Dure d'activation de l'alarme en secondes (60 sec. par dfaut)
#define	TEMPO_REL_T     .05	; Dure d'activation du relais temporis en minutes (5 par dfaut)
 						; en plus de la dure TEMPO_ALA.
#define TYPE_NO_NF	0x3f00 	; Pour des contacts NO = 0x00, pour des contacts NF = 0x3F.

;Il doit tre possible de mlanger en entre les contacts 'NF' et NO' en plaant dans la variable
; 'TYPE_NO_NF' un bit  1 pour chaque entre de type 'NF' suivant le format suivant.
;  Format recompos des bits d'entre aprs lecture du Port A et du Port B
;   7 6 5 4  3 2 1 0 
;   - - P P  B F F P
;   - - 1 P  O 2 1 2  


#define	PORT_LEDS	PORTB
#define	BIT_LED_V      0x10	; Bit de sortie de la led verte
#define	BIT_LED_O      0x20	; Bit de sortie de la led orange + buzzer
#define	BIT_LED_R      0x40	; Bit de sortie de la led rouge
#define	LED_V       PORTB,4	; Led verte
#define	LED_O       PORTB,5	; Led orange + buzzer
#define	LED_R       PORTB,6	; Led rouge

#define	PORT_REL_F	PORTA
#define	PORT_REL_C	PORTA
#define	PORT_REL_T	PORTB
#define	BIT_REL_F      0x80	; Bit de sortie du relais fixe
#define	BIT_REL_T      0x02	; Bit de sortie du relais temporis
#define	BIT_REL_C      0x01	; Bit de sortie du relais clignotant
#define	REL_C       PORTA,0	; Relais clignotant (2Hz)
#define	REL_T       PORTA,1	; Relais Temporis (5mn)
#define	REL_F       PORTB,7	; Relais fixe (20 sec)

#define	PORTE_P     PORTA,2	; Porte principale
#define	PORTE_1     PORTA,3	; Porte 1
#define	MODE_TEST   PORTA,4	; 0 Volt = mode test
#define	PORTE_2     PORTB,0	; Porte 2
#define	FENETRE_1   PORTB,1	; Fentre 1
#define	FENETRE_2   PORTB,2	; Fentre 2
#define	BOITIER     PORTB,3	; Boitier

; Format recompos des bits d'entre aprs lecture du Port A et du Port B
;   7 6 5 4  3 2 1 0 
;   - - P P  B F F P
;   - - 1 P  O 2 1 2  

#define	PP		0X10	; Bit porte principale
#define	PFB		0X2F	; Bits portes fentres boitier
#define	PPFB		0X3F	; Bits porte principale portes fentres boitier


#define	Page0  BCF STATUS,5	; Active le bank 0
#define	Page1  BSF STATUS,5	; Active le bank 1

;*********************************************************************
;                   DECLARATIONS DE VARIABLES                        *
;*********************************************************************
	CBLOCK        0x00C 	; Dbut de la zone variables
	Etat_in :         1	; Etat des entres
	Etat_in2 :        1	; Etat des entres
	Etat_in_PP :	1	; Etat des entres du port B,Porte Principale
	Etat_in_PFB :	1	; Etat entres port B,Botier Fentres Portes
	Nbalarme :	1	; Nombre d'alarme encore sonores
	Tempo :		1	; Compteur de temporisation gnrale
	Cmptenv :	1	; Compteur en veille
	Cmpt1 :           1	; Compteur de boucles 1
	Cmpt2 :           1	; Compteur de boucles 2
	Cmptt1 :          1	; Tempo. relais temporis 1er compteur
	Cmptt2 :          1	; Tempo. relais temporis 2eme compteur
	Nbboucle :        1	; Nombre de boucle a effectuer (localement)
	Sauvew :          1	; Sauvegarde temporaire du registre w
	ENDC                   ; Fin de la zone

;*********************************************************************
;                      DEMARRAGE SUR RESET                           *
;*********************************************************************
	org      0x000	; Adresse de dpart aprs reset
  	goto     Init	; Adresse 0 = saut vers Init.
	org      0x004	; Adresse de dpart aprs interruption
  	goto     Init	; Adresse 0 = saut vers Init.

;*********************************************************************
;                       INITIALISATIONS                              *
;*********************************************************************

Init	clrf	PORTA	; Sorties portA  0
	clrf	PORTB	; Sorties portB  0
	Page1		; Slectionner banque 1
	clrf	EEADR	; Permet de diminuer la consommation
	movlw	OPTIONVAL	; Charger masque
	movwf	OPTION_REG	; Initialiser registre option
	movlw	b'00011100'	; Port A : Bits 2+3+4 en entres
	movwf	TRISA
	movlw	b'00001111'	; Port B : Bits 0+1+2+3 en entres
	movwf	TRISB
	Page0		; Slectionner banque 0
	movlw	INTERMASK	; masque interruption
	movwf	INTCON		; charger interrupt control
	call	Tempo05	; On attend 0,5 secondes pour charger les capas d'entre
	btfss	MODE_TEST	; Mode = mode test (par cavalier externe) ?
	Goto	Test1	; oui
	clrf	Cmptt1
	movlw	TEMPO_REL_T
	movwf	Cmptt2
	movlw	NB_MAX_ALA
	movwf	Nbalarme	; Maximum d'alarmes sonores = NB_MAX_ALA

;*********************************************************************
;            PROGRAMME INITIAL, TEMPORISATION POUR SORTIR            *
;*********************************************************************
; On passe dans cette routine si le cavalier RA[4] est positionn  +5V.
;*********************************************************************

	bsf	LED_V	; Allume la led verte
	movlw	TEMPO_INIT
	addlw	TEMPO_INIT
	addlw	TEMPO_INIT
	movwf	Tempo	; Tempo = 3 * TEMPO_INIT = Nb de boucle  faire

Demar1	btfsc	PORTE_P	; Porte principale ouverte ?
	goto	Demar3	; non
	btfss	LED_R	; Si la led rouge est allume, alors on
	goto	Demar2	; allume la led orange + buzzer en continu
	bsf	LED_O
	goto	Demar4

Demar2	movlw	BIT_LED_O	; Si oui, on change d'tat led orange
	xorwf	PORT_LEDS,f
	goto	Demar4
Demar3	bcf	LED_O	; Porte Principale ferme => on teint la led orange

Demar4	call	Lec_etat
	andlw	PFB
	sublw	PFB
	btfsc	STATUS,Z
	goto	Demar5
	bsf	LED_R	; Portes1ou2,fentres ou boitier ouvert => On allume la led rouge
	goto	Demar6
Demar5	bcf	LED_R	; Eteint la led rouge

Demar6	call	Tempo03	; Tempo 300 ms
	decfsz	Tempo,f
	goto	Demar1


;*********************************************************************
;                      BOUCLE DE VEILLE                              *
;*********************************************************************
; On attend un changement d'tat des contacts.
;*********************************************************************

Veille1	bcf	LED_V	; Eteint la led verte
	bcf	LED_O	; Eteint la led orange
	bcf	LED_R	; Eteint la led rouge
	bcf	REL_C	; Arrte le relais clignotant
	bcf	REL_F	; Arrte le relais fixe

	call	Lec_etat
	movwf	Etat_in	; Etat_in = 00XX XXXX
	movwf	Etat_in_PP
	movwf	Etat_in_PFB
	movlw	PP
	andwf	Etat_in_PP,f	; Etat_in_PP  = tat Porte Principale
	movlw	PFB
	andwf	Etat_in_PFB,f	; Etat_in_PFB = tat Botier,Fentres,Portes

Veille2	call	Lec_etat
	movwf	Sauvew
	andlw	PFB
	xorwf	Etat_in_PFB,w	; = "00000010" si l'entre n2 a boug
	btfss	STATUS,Z
	goto	Alarme1	; Va directement en squence alarme

	movfw	Sauvew
	andlw	PP
	xorwf	Etat_in_PP,w	; = "00000001" si la porte principale a boug
	btfss	STATUS,Z
	goto	Preala1	; Va en squence pr-alarme

	incfsz	Cmptenv,f	; 
	goto	Veille4
;
; On passe ici une fois toute les secondes (256 * 4 ms).
;
	btfss	REL_T	; Relais temporis actif ?
	goto	Veille4	; non!

	decfsz	Cmptt1,f	; Dcrmente Cmptt1,Cmptt2 = 24,TEMPO_REL_T
	goto	Veille4	; Cmptt1 <> 0, oui !

	decfsz	Cmptt2,f
	goto	Veille3	; Cmptt2 <> 0, oui !

	bcf	REL_T	; arrte le relais temporis.
Veille3	movlw	.24	; Cmptt1 compte les minutes
	movwf	Cmptt1

Veille4	call	Tempo0004	; Tempo0004 de 4 ms + 4ms dans Veille2 = 8ms au total
	goto	Veille2

;*********************************************************************
;                      BOUCLE DE PREALARME                           *
;*********************************************************************
; On est entr par la porte.
; Activation de la temporisation de pr-alarme de TEMPO_PREALA secondes
; avant l'activation de l'alarme.
;*********************************************************************

Preala1	movlw	TEMPO_PREALA
	addlw	TEMPO_PREALA
	movwf	Tempo	; Tempo = 2 * TEMPO_PREALA, car 0,5 sec / boucle
	movfw	Nbalarme	; A t'on dj eu une alarme ?
	sublw	NB_MAX_ALA
	btfss	STATUS,Z	; Nbalarme <> NB_MAX_ALA ?
	bsf	LED_R	; Si oui, allume la led rouge
	call	Lec_etat
	andlw	PFB
	movwf	Etat_in_PFB	; EtatRBBFP = tat Botier,Fentres,Portes

Preala2	btfss	LED_R	; Si la led rouge est allume, alors on
	goto	Preala21	; allume la led orange+buzzer en continu
	bsf	LED_O
	goto	Preala22
Preala21	movlw	BIT_LED_O
	xorwf	PORT_LEDS,f	; Change l'tat de la led orange
Preala22	movlw	.65	; 0,5 sec. = 65 * 4 ms + prg preala
	movwf	Nbboucle

Preala3	call	Tempo0004	; On boucle "Nbboucle" fois 4 milli sec.
	call	Lec_etat
	andlw	PFB
	xorwf	Etat_in_PFB,w	; = "00000010" si l'entre n2 a boug
	btfss	STATUS,Z
	goto	Alarme1	; Va directement en squence alarme
	decfsz	Nbboucle,f	; Decrmenter Nbboucle
	goto	Preala3	; Si Nbboucle <> 0, recommencer boucle

	decfsz	Tempo,f	; Dcrmenter le temps de pr-alarme
	goto	Preala2	; Si <> 0, recommencer boucle
	goto	Alarme1	; Sinon on va en squence d'alarme

;*********************************************************************
;                      BOUCLE D'ALARME                               *
;*********************************************************************
; On a ouvert le botier, une fentre ou une porte interne, ou
; on a dpasse la temporisation de pr-alarme.
;*********************************************************************
	
Alarme1	bcf	LED_V	; Eteint les 3 leds pour rester discret 
	bcf	LED_O
	bcf	LED_R
	movlw	TEMPO_ALA
	addlw	TEMPO_ALA
	movwf	Tempo	; Tempo = 2 * TEMPO_ALA, car 0,5 sec / boucle
	movfw	Nbalarme
	sublw	0
	btfsc	STATUS,Z	; Nbalarme = Nombre d'alarmes sonores
	goto	Alarme2	; si = 0 pas d'activation des relais
	bsf	REL_F	; Active les relais d'alarme fixe et 
	bsf	REL_C	; clignotant

Alarme2	movlw	TEMPO_REL_T	; Active la temporisation du relais
	movwf	Cmptt2	; temporis.
	movlw	.24	; Cmptt1 compte les minutes
	movwf	Cmptt1
	bsf	REL_T	; Active le relais temporis

	call	Lec_etat
	movwf	Etat_in

Alarme3	call	Lec_etat
	andlw	PPFB
	xorwf	Etat_in,w	; = "00000010" si l'entre 1 a boug
	btfss	STATUS,Z
	goto	Alarme1	; Si a a boug, raz de la tempo d'alarme

	call	Tempo05
	movfw	Nbalarme
	sublw	0
	btfsc	STATUS,Z	; Nbalarme = Nombre d'alarmes sonores
	goto	Alarme4	; si = 0 pas d'activation des relais
	movlw	BIT_REL_C
	xorwf	PORT_REL_C,f	; Change d'tat le relais 2 (clignotant)

Alarme4	decfsz	Tempo,f	; Dcrmenter le temps d'alarme
	goto	Alarme3	; si <> 0, recommencer boucle

	movfw	Nbalarme
	sublw	0
	btfsc	STATUS,Z	; Alarmes pas sonores ?
	goto	Veille1	; Si oui, retour directement en veille

	decf	Nbalarme,f
	bcf	REL_C	; Arrt du relais clignotant
	bcf	REL_F	; Arrt du relais fixe
	goto	Veille1

;*********************************************************************
;                      PROGRAMME DE TEST                             *
;*********************************************************************
; On passe dans cette routine, si le cavalier RA[4] est positionn  0V.
; Le programme reste indfiniment en mode test, jusqu'au prochain reset.
; Dans cette squence, on met un certain nombre de bips buzzer  chaque
; ouverture ou fermeture de contact.
; De plus - si le contact est maintenant ferm, la led verte s'allume.
;         - si le contact est maintenant ouvert, la led rouge s'allume.
;
; Si l'on ferme ou ouvre la porte principale : 1 bip buzzer
;           //           la porte 1          : 2 bips buzzer
;           //           la porte 2          : 3 bips buzzer
;           //           la fentre 1        : 4 bips buzzer
;           //           la fentre 2        : 5 bips buzzer
;           //           le boitier          : 6 bips buzzer
;*********************************************************************

Test1	call	Lec_etat
	movwf	Etat_in

Test2	call	Lec_etat
	movwf	Etat_in2
	xorwf	Etat_in,w	; w = "00000010" si l'entre X a boug
	btfsc	STATUS,Z
	goto	Test2
;
; Si un contact est ferm alors ?
; Une entre a boug. Nbboucle = Nb de sonnerie  ffectuer.
; Exemple : W = "00000010" si l'entre n1 a boug.
;
	movwf	Etat_in	; Etat_in = "00000010" si l'entre n2 a boug
	movfw	Etat_in2
	andwf	Etat_in,w	; W = 0 ou <> 0 suivant l'tat de l'entre
	btfsc	STATUS,Z	; Contact ferm = Rb[x] ? : W = 0 ?
	goto	Test3
	bsf	LED_V	; Contact ferm : Allume la led verte
	nop		; 'nop' entre 2 critures successives
	bcf	LED_R	; Contact ferm : Eteint la led rouge
	goto	Test4
Test3	bcf	LED_V	; Contact ouvert : Eteint la led verte
	nop		; 'nop' entre 2 critures successives
	bsf	LED_R	; Contact ouvert : Allume la led rouge
	
Test4	btfsc	Etat_in,4
	movlw	.1	; Porte principale ouverte? : Si oui, 1 boucle
	btfsc	Etat_in,5
	movlw	.2	; Porte 1 ouverte ?   : Si oui, 2 boucles
	btfsc	Etat_in,0
	movlw	.3	; Porte 2 ouverte ?   : Si oui, 3 boucles
	btfsc	Etat_in,1
	movlw	.4	; Fentre 1 ouverte ? : Si oui, 4 boucles
	btfsc	Etat_in,2
	movlw	.5	; Fentre 2 ouverte ? : Si oui, 5 boucles
	btfsc	Etat_in,3
	movlw	.6	; Botier ouvert ?    : Si oui, 6 boucles
	movwf	Nbboucle
	goto	Test6

Test5	call	Tempo05
Test6	bsf	LED_O	; Allume la led orange + buzzer
	call	Tempo05	; pendant 0,5 seconde
	bcf	LED_O	; Eteint la led orange + buzzer
	decfsz	Nbboucle,f
	goto	Test5	; Nbboucle <>0 Si oui, on reboucle en Test5
	goto	Test1

;*********************************************************************
;                  SOUS-ROUTINES DE TEMPORISATION                    *
;*********************************************************************
;---------------------------------------------------------------------
; Ces sous-routine introduisent un retard de
;   Tempo0004  =   4 milli secondes (0,0004 sec.)
;   Tempo001   =  10 milli secondes (0,0010 sec.)
;   Tempo03    = 300 milli secondes (0,3 sec.)
;   Tempo05    = 500 milli secondes (0,5 sec.)
;
; Modifie la variable = Cmpt1
; Elles ne reoivent aucun paramtre et n'en retourne aucun.
;---------------------------------------------------------------------

Tempo0004
	movlw	.8	; 4 ms = environ 8 boucles  Horloge = 32Khz
	movwf	Cmpt1	; effacer compteur1
tempo_a	nop		; perdre 1 cycle
	decfsz	Cmpt1,f	; dcrmenter compteur1
	goto	tempo_a	; si pas 0, boucler
	return
;---------------------------------------------------------------------

Tempo001
	movlw	.19	; 10 ms = environ 19 boucles  Horloge = 32Khz
	movwf	Cmpt1	; Effacer Cmpt1
tempo_b	nop		; perdre 1 cycle
	decfsz	Cmpt1,f	; Dcrmenter Cmpt1
	goto	tempo_b	; si pas 0, boucler
	return
;---------------------------------------------------------------------

Tempo03 movlw	.32	; 330 ms = environ 32 boucles de 10 ms.
	movwf	Cmpt2
tempo_c	call	Tempo001
	decfsz	Cmpt2,f	; Dcrmenter Cmpt2
	goto	tempo_c	;
	return
;---------------------------------------------------------------------

Tempo05 movlw	.48	; 500 ms = environ 48 boucles de 10 ms.
	movwf	Cmpt2
tempo_d	call	Tempo001
	decfsz	Cmpt2,f	; Dcrmenter Cmpt2
	goto	tempo_d	;
	return

;*********************************************************************
;              SOUS-ROUTINES DE LECTURE DES ENTREES                  *
;*********************************************************************
;---------------------------------------------------------------------
; Cette sous-routine lit les tats des portes, boitier et fentres
; Elle ne reoit pas de paramtre et retourne la valeur dans w.
; Format recompos des bits d'entre aprs lecture du Port A et du Port B
; W = 7 6 5 4  3 2 1 0 
;     - - P P  B F F P
;     - - 1 P  O 2 1 2  
; Modifie la variable = Cmpt1
;---------------------------------------------------------------------

Lec_etat
	movfw	PORTA
	andlw	0x0C
	movwf	Cmpt1
	bcf	STATUS,C
	rlf	Cmpt1,f
	bcf	STATUS,C
	rlf	Cmpt1,f
	movfw	PORTB
	andlw	0x0F
	iorwf	Cmpt1,w	; w = 00XX XXXX = tat des entres
        xorlw	TYPE_NO_NF
	return

	END